package org.msh.tb.cases.adsm;

import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.faces.FacesMessages;
import org.msh.etbm.commons.transactionlog.mapping.LogInfo;
import org.msh.tb.cases.CaseHome;
import org.msh.tb.entities.CaseSideEffect;
import org.msh.tb.entities.enums.CaseSideEffectType;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;

@Name("seriousAdverseEventHome")
@LogInfo(roleName="ADV_EFFECTS", entityClass=CaseSideEffect.class)
public class SeriousAdverseEventHome extends SideEffectHome {

    @In
    CaseHome caseHome;
    @In(create=true)
    FacesMessages facesMessages;

    @Factory("seriousAdverseEvent")
    public CaseSideEffect getCaseSideEffect() {
        return getInstance();
    }

    @Override
    public CaseSideEffectType getType() {
        return CaseSideEffectType.SERIOUS_ADVERSE_EVENT;
    }

    @Override
    protected CaseHome caseHome() {
        return caseHome;
    }

    @Override
    protected FacesMessages facesMessages() {
        return facesMessages;
    }

    @Override
    public Class<CaseSideEffect> getEntityClass() {
        return CaseSideEffect.class;
    }

    public List<SelectItem> getSeverities() {
        List<SelectItem> lst = new ArrayList<SelectItem>();
        String[] strMonths = {"1","2","3","4","5"};

        for (int i = 0; i< strMonths.length; i++) {
            SelectItem item = new SelectItem();
            item.setLabel(strMonths[i]);
            item.setValue(strMonths[i]);
            lst.add(item);
        }

        return lst;
    }

}
